### v6.0.0 [多平台弹幕、AI分析、语法增强、实时档案](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v6.0.0)

> 使用“功能型AI”的用户请注意：由于更改了AI分析的逻辑，请点击该项设置中“还原/升级”的按钮

- 新增抖音发送弹幕（测试）
- 新增弹幕姬显示粉丝的历史弹幕、档案
- 新增实时显示最新一条弹幕的用户档案
- 新增简单计算的JS语法，示例：`%<var a = 10, b = 12; a + b>%`
- 新增新的语言框架：QML，可自定义显示界面
- 新增默认弹幕JS的WebSocket支持断开自动重连
- 新增设备更换检测，自动清除Cookie以保障安全
- 新增不同直播平台的房间号与Cookie使用不同的配置
- 重构“功能型AI”为“AI分析”，支持多条弹幕批量解析，在弹幕数量超多时节省大量资源
- 优化AI回复，在不开启弹幕姬的情况下也可以回复
- 优化以 "%[xxx]%" 包裹的计算器功能，支持嵌套括号
- 优化本地模式下，发送至其他直播间的弹幕也将不发送（之前版本仅限自己直播间）
- 优化语法糖字符串运算符，示例：重复2次 `{字符串值} * 2`
- 优化切换平台时禁用一些无效功能的UI控件
- 优化弹幕姬修改标签样式使用多行输入框
- 优化弹幕姬默认文字与背景色，并且使用窗口模式
- 修复启动时关闭界面导致多线程异常崩溃的问题





### v5.5.0 [抖音弹幕、代码可视化编辑器](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v5.5.0)

- 新增支持直播平台：抖音，已实现部分功能。
  - 包括：获取弹幕、进房、送礼、关注、点赞、Cookie登录、人数统计等信息
  - 不包括：发送弹幕、录播、PK、礼物连击等功能
- 新增代码GUI编辑器，支持可视化操作逻辑
- 新增代码定义的列表，包含变量、函数等，双击插入编辑器
- 新增直播状态码变量 `%live_status_code%` 和 `%live_status_str%`，可用于判断直播间状态
- 新增一键还原默认功能型AI配置的按钮，适用于随版本手动升级
- 新增浏览器登录功能（仅限特殊的带浏览器版）
- 优化功能型AI，添加直播建议、直播内容识别、观众情绪等功能
- 优化自动获取弹幕长度上限的接口（会触发进入直播间）
- 调整所有用户ID结构都调整为字符串类型，可能会引发新的兼容问题





### v5.4.1 [修复用户欢迎失效](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v5.4.1)

- 修复部分直播间用户欢迎失效
- 新增弹幕姬支持用户进入的舰长等级显示
- 新增欢迎消息支持粉丝牌对应的主播ID：`%medal_uid%`





### v5.4 [Cron 定时事件、过滤器支持在线AI、Python虚拟环境](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v5.4)

- 新增粉丝档案的观众消费能力分析
- 新增 Cron 定时事件：以`TIME:`开头
- 新增网络代理功能，支持HTTP合SOCKS5
- 新增过滤器支持多个编程语言和代码文件
- 新增手动设置Python虚拟环境
- 新增JS语法支持网络连接，可使用在线数据
- 新增过滤器事件支持使用JS语法的AI判断
- 新增多个场景下自动设置BuVID字段
- 优化启动10秒内不进行自动化操作（包括定时、回复、事件、过滤器等）
- 优化部分控件的交互
- 修复过滤器在空代码时返回值错误的问题
- 修复粉丝档案没有选中时导致崩溃的问题
- 修复子账号导致进入主页链接错误的问题





### v5.3.0 [功能型AI](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v5.3.0)

- 新增代码支持以本地文件的形式加载，可使用其他IDE来编写与管理
- 新增代码块可通过 `---` 拆分为多段代码执行
- 新增代码规则：代码展开
- 新增代码展开的函数 `traverseJson`，用来遍历JSON数组
- 新增函数 `ignoreEmpty`，忽略括号包裹的空内容
- 新增功能型AI的知识点显示
- 新增长连接断开重连成功的提示
- 新增读写程序的配置接口
- 优化“功能型AI”的类型，完善细节
- 优化开关“功能型AI”时清空 AI 记录
- 优化清理过多的弹幕记录，以节省内存
- 优化多次重新加载配置的行为
- 优化JSON路径的解析，不存在时返回空字符串
- 修复最新版本托盘退出显示中断更新的问题
- 修复“功能型AI”偶尔无法解析结果的问题
- 修复语音朗读在重启后会导致崩溃的问题
- 修复 Mac 上微软语音无法播放的问题
- 修复 PK 对面直播间信息的鉴权问题





### v5.2.0 [子账号、修复bug](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v5.2.0)

- 新增子账号功能（捐赠版），可使用不同的账号来发送弹幕
- 新增保持账号登录功能（捐赠版，仅限扫码登录）
- 新增自定义 UserAgent
- 优化 `sendRoomMsg()` 等命令也支持子账号
- 修复无法获取弹幕信息的问题
- 修复部分 UID 长的账号会一直 AI 回复自己的问题
- 修复部分网络连接UA的问题
- 修复 Mac 上恰饭窗口偶尔崩溃的问题
- 修复人气值为 1 的问题
以下感谢用户 @TiAmoPlus 的 PR：
- 优化 PostJson 函数中换行的处理
- 优化礼物 ID 列表接口，适配直播间礼物列表
- 修复直播间标题多行时的情况
- 修复 PK 时无法获取到最佳助攻的问题
- 修复默认代码中 PK_FINAL 的遗留问题
- 修复 README 中下播事件写作 PREPARE 的问题






### v5.1.0 [代码支持多种编程语言](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v5.1.0)

- 新增代码支持 JavaScript、Python、Lua 三种编程语言，并且可参与读写配置数据
- 新增模型名称可以自由输入
- 新增 GPT 输入消息 JSON 中添加键值对 UID，以便大模型识别
- 优化远程开关粉丝档案时忽略未改变的情况
- 优化代码编辑器的 tab 宽度为4个空格宽度
- 优化未登录时 -352 报错显示需要登录的提示
- 修复模型自定义 API 无法保存的问题
- 修复初次上船 FIRST_GUARD 反过来的问题
- 修复代码页切换无法保存的问题





### v5.0.0 [粉丝档案、数据库优化](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v5.0.0)

- 新增粉丝档案功能，解析每一位观众的行为特征
- 移动数据库至数据中心页面
- 新增数据库查询可直接问AI
- 新增数据库可视化列表的变量输入
- 新增SQL查询支持注释
- 新增SQL查询支持中文字符集
- 新增数据库路径可自定义：setting.ini中 `[custom]` 下添加 `databasePath=xxxx(需包含文件名)`
- 新增全屏弹幕的显示器选择
- 新增发送常规的@符号，使用"\@"代替
- 新增远程控制命令“开启粉丝档案/关闭粉丝档案”
    
    > 结合定时任务，可以实现DeepSeek错峰使用
- 修复SQL浏览器无法执行多行的问题
    
    > 因为该文本格式中，换行符使用的是特殊的 Unicode 字符 U+2029 (Paragraph Separator)，而不是常规的 \n 字符
- 修复弹幕在失败重发时丢失@用户的问题





### v4.10.9 [发送表情命令](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.9)

- 新增AI“回复自己”的开关，避免死循环（默认关闭，不会回复）
- 新增发送表情命令：`>sendEmoji(emojiID)`、`>sendRoomEmoji(roomID, emojiID)`
- 新增自定义变量支持正则表达式，以此衍生的自定义函数功能
> 示例：自定义发送表情的函数，自定义变量添加：
> ```
> >发送表情\((.+?)\) = >postData(https://api.live.bilibili.com/msg/send, bubble=0&msg=\1&color=16777215&mode=1&dm_type=1&fontsize=25&rnd=1657851774&roomid=%room_id%&csrf=%csrf%&csrf_token=%csrf%)
> ```
> 之后就可以在代码框中使用 `>发送表情(official_147)` 这样的格式来快速写发送表情。





### v4.10.8 [支持DeepSeek](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.8)

- 新增DeepSeek接口（感谢github/hot1989hot）





### v4.10.7 [修复接口、@用户](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.7)

- 新增支持@用户的弹幕
- 新增弹幕姬的右键菜单直接@用户
- 新增礼物ID变量 `%gift_id%`
- 新增财富等级 `%wealth_level%`
- 新增点歌姬支持本地/自定义API
- 优化通过uid找uname失败时使用uid数字
- 修复弹幕头像问题
- 修复舰长数量问题
- 修复语音设置启动后会变回“其他”的问题





### v4.10.6 [小优化](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.6)

- 修复无法扫码登录问题
- 新增在标题栏显示版本号
- 新增未登录连接直播间时的受限提示
- 新增本场直播的数据统计与导出
- 新增变量：开播时间戳 `%live_start_timestamp%`
- 新增变量：开播时长 `%live_duration_second%`
- 新增默认的自定义变量配置：`%upname% = %up_uname%`
- 优化鼠标穿透在设置中直接切换开关
- 修复欢迎的语音播报会朗读换行符的问题





### v4.10.5 [修复弹幕接口](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.5)

- 修复无法读取弹幕的问题
- 添加盲盒礼物实际价值 `%discount_price%`
- 新增自动回复可覆盖内置弹幕控制命令，不再重复执行
- 新增AIChat()命令的回复也使用FILTER_AI_REPLY_MSG过滤器
- 优化更快速度重连直播间
- 优化多行代码中对英文双引号的处理
- 修复带&符号无法发送的问题





### v4.10.4 [ChatGPT控制、弹幕姬优化、邮件服务](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.4)

- 新增显示直播间开播时长
- 新增语音朗读发送者昵称开关
- 新增隐藏礼物价格开关
- 新增Mac下弹幕姬支持原生窗口模式
- 新增Mac下对H5插件功能的支持
- 新增智能分割超长弹幕进行发送
- 新增显示全屏弹幕的命令 `showScreenDanmu(text)`
- 新增 `ChatGPT()` 命令，调用GPT进行回复
- 调整 `AIChat()` 细化为 `TXChat()` 和 `ChatGPT()` 两项
- 新增AI回复过滤器：`FILTER_AI_REPLY` 和 `FILTER_AI_REPLY_MSG`，控制回复时机
- 新增邮件服务，发送邮件命令 `sendEmail()`（目前仅支持腾讯企业邮箱）
- 优化AI回复对长弹幕的分割粒度
- 优化弹幕姬菜单中的手动AI回复
- 修复PK贡献分数问题



​	

### v4.10.3 [AI生成脚本](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.3)

- 新增GPT-16k模型的支持
- 新增GPT生成/修改/解释/审阅代码
- 新增数据库可视化列表和按钮
- 修复认证包UID问题
- 修复微软语音偶尔超时的问题




### v4.10.2 [GPT问题修复](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.2)

- 新增在已实现关键词回复时不进行AI回复
- 新增在点歌开启时点歌格式忽略AI回复
- 新增保存自动生成的GPT事件
- 修复GPT容易崩溃的问题
- 修复UID很长时无法复制的问题
- 修复Mac下图标问题
- 修复下播信号丢失的问题





### v4.10.1 [功能型GPT](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.1)

- 新增“功能型GPT”：智能识别弹幕类型并进行操作
- 新增 AIReply 命令支持自动调用 ChatGPT
- 优化部分界面
- 修复头像接口问题
- 修复弹幕姬中“<% %>”无法显示的问题

功能型GPT：智能识别弹幕的内容，进行自定义操作
- 不良言论：高于一定程度则禁言
- 点歌：不再局限于格式与歌名
- 任务/提醒：本地提醒
- 聊天/互动：闲聊自动回复
- 问题/百科/计算：回答问题
- 外语：自动翻译




### v4.10.0 [GPT接入](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.10.0)

- 新增ChatGPT功能，可选3.5/4等多个模型
- 新增GPT参数配置的界面
- 新增AI弹幕回复的选择界面，可用GPT/腾讯
- 修复账号接口失效的问题





### v4.9.2 [Win API接入](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.9.2)

- 调整移动鼠标 `moveMouse` / `moveMouseTo` 为 `adjustMouse` / `moveMouse`
- 新增显示窗口、移动窗口、发送窗口消息等多个命令
- 新增查找窗口、前景窗口、窗口大小、鼠标位置等多个函数
- 优化按键模拟支持16进制的参数用于模拟所有按键
- 修复二维码登录失效的问题
- 修复高能榜失效的问题





### v4.9.1 [游戏统计、函数封装](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.9.1)

- 新增获取屏幕宽高的函数
- 新增截图命令、截图比较函数，用于游戏统计
- 新增多种图片相似度算法
- 新增`call`命令，带参数调用事件的代码（函数封装）
- 新增扩展支持exe、bat的封装，点击即可打开
- 优化命令执行间隔，没有弹幕的代码不再有延迟
- 优化智能闲聊，过滤一些失败的话
- 优化弹幕姬右键菜单的用户信息粉丝数精简到万
- 优化数据库多行查询
- 更新百度语音合成接口
- 修复关闭界面效果弹幕姬没滚动到最新弹幕的问题





### v4.9.0 [修复bug、性能优化](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.9.0)

这个版本开始彻底重构代码，可能会出现一些功能无效的情况，请及时反馈

- 新增禁言操作包含弹幕信息
- 优化长时间接收大量弹幕的性能
- 调整“关闭界面效果”关闭弹幕动画
- 修复直播流视频无法加载的问题
- 修复无法录播的问题
- 修复点歌姬偶尔无法点歌的问题
- 修复动画可能导致内存泄漏的问题
- 修复有些礼物图片加载失败的问题





### v4.8.3 [修复连接](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.8.3)

- 优化点歌姬缓存路径至系统缓存
- 修复部分设备上无法连接直播间的问题
- 修复无法获取大乱斗信息的问题
- 修复PK开启同步后对面直播间弹幕存入数据库的问题





### v4.8.2 [修复音乐接口](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.8.2)

- 优化点歌姬清理缓存可清理点歌候选
- 修复网易云音乐和QQ音乐的搜索失效的问题





### v4.8.1 [录播](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.8.1)

- 重构录播机制，优化缓冲区，保存时再也不卡顿了
- 新增显示录播时长与文件大小
- 新增使用FFmpeg对录播格式进行自动转换
- 新增存储所有CMD用来进行日志查询
- 调整数据库为捐赠版功能
- 调整将机器人的弹幕也放入到数据库中
- 调整点歌姬的导入在线歌单与本地歌曲到右上角菜单中
- 优化copyText、speakText、messageBox命令支持%n%换行
- 优化昵称简化算法
- 修复点歌姬黑名单的问题
- 修复PK绝杀时刻无法提前结束的问题





### v4.8.0 [数据库](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.8.0)

- 新增保存所有记录到SQLite数据库
- 新增SQL语句的批量编辑与运行
- 新增SQL命令：`SQLQuery`、`SQLExec`
- 新增显示数据库查询结果
- 新增显示直播总榜和看过人数
- 新增显示分区榜的排名
- 新增打开录播存储位置的按钮
- 新增自动填充事件名字的候选框
- 新增弹幕姬的弹幕单独一行开关
- 新增代理支持动态header参数
- 新增点歌姬设置音频输出设备
- 新增点歌姬图标设置为用户头像
- 新增弹幕姬获取头像的冷却机制
- 新增升级后显示更新内容
- 新增扩展的打赏、联系作者
- 新增扩展自定义菜单
- 新增退出登录的账号
- 优化代码符号的自动补全
- 调整高能榜和礼物的列表界面
- 默认取消点歌条件，开箱即用
- 修复上船没有gift_id的问题
- 修复舰长进入的问题
- 新增多个查询方式，可配置用户、日期、关键词等条件
    - 所有弹幕历史
    - 指定用户弹幕历史
    - 关键词搜索
    - 重复弹幕统计（包含天选）
    - 进入直播间历史
    - 进入次数统计
    - 关注历史
    - 分享直播间历史
    - 特别关注
    - 最近七天的关注
    - 礼物历史
    - 按用户消费总额统计
    - 按月流水统计
    - 舰长购买记录
    - 按月舰长统计
    - 点歌历史
    - 按歌名统计次数





### v4.7.2 [优化与修复](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.7.2)

- 新增空代码框中粘贴代码片段自动识别并添加
- 新增“智能点歌”开关：点歌播放第一条结果还是按关键词匹配程度筛选
- 新增包含屏蔽词的错误说明
- 新增切换直播间命令`connectRoom(roomId)`
- 新增`>sendLongText()`支持发送`%n%`分隔多条弹幕
- 新增`>getData()`等网络函数的回调事件使用`%text%`获取返回的原始文本
- 优化通知卡片的显示
- 优化重启后列表恢复之前的位置
- 调整禁言页面到欢迎这一栏中
- 调整README中Web接口的一些说明
- 调整回复、事件等功能的标签名字
- 修复舰长进场提示两次的问题
- 修复录播失效的问题
- 修复咪咕开启验证时间下选择歌曲问题
- 修复发送长文本的弹幕分割长度问题





### v4.7.1 [修复](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.7.0)

- 紧急修复计算表达式不规范时的错误





### v4.7.0 [点歌姬优化、任命房管](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.7.0)

- 新增弹幕姬菜单直接任命与取消房管，并显示任命情况
- 新增任命房管的命令：`appointAdmin(uid)`
- 新增撤销房管的命令：`dismissAdmin(uid)`
- 新增`KEY:`开头的事件变为全局快捷键
- 新增显示在线高能榜列表
- 新增点歌姬恢复网易云ID点歌
- 新增歌手与歌名的黑名单，可排除翻唱、伴奏
- 新增点歌姬排除一分钟以下的试听音乐开关
- 新增全屏滚动弹幕显示昵称开关
- 新增重复弹幕的相似度过滤算法
- 新增微软语音试听，可免费试用
- 新增显示所有可送出的礼物信息
- 新增TTS播放状态变量：`%playing_tts%`
- 新增获取鼠标XY坐标变量
- 优化自带的弹幕朗读忽视重复弹幕
- 优化一部分控件的显示与交互
- 优化展开歌词时立即跳转到当前行
- 优化托盘菜单中显示更新状态
- 调整QQ音乐绿钻可能失效的说明
- 显示网易云音乐登录不上的真实报错
- 修复直播视频无法播放的问题
- 修复点歌失败后重新搜索的一个小问题





### v4.6.1 [优化点歌姬、自定义机器人](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.6.1)

- 新增点歌姬设置音源开关和顺序
- 新增音乐无版权的文字提示
- 新增AI回复过滤重复弹幕（抽奖、天选等）
- 新增重启软件后已添加到直播姬/OBS的音乐插件自动重连
- 新增与最近10条弹幕的判断变量 `%repeat_10%`
- 新增 `>postHeaderData(url, headers, data, event)` 命令，可用于上传带 Header 的 post
- 调整 `NEW_HOUR` 为整点触发，而不是从程序启动开始
- 显示打印日志到文件的显式开关
- 更新扩展的自带代码
- 默认关闭翻译、新观众提醒等影响性能的功能
- 修复QQ音乐强制换源的问题





### v4.6.0 [添加命令、优化点歌姬、修复bug](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.6.0)

- 新增播放在线语音命令：`speakTextUrl(url)`
- 新增几个代码语法糖，如 `{积分}=1`、`{打卡}++`
- 新增一些文本文件操作函数和命令
- 新增URL编码与解码函数：`urlEncode`和`urlDecode`
- 新增单行与多行的转换`%n%`，支持发送多行私信
- 新增打开弹幕历史记录的按钮
- 新增论坛按钮
- 新增插件封面、作者的显示
- 优化弹幕设置中复选框的动画效果
- 优化发送指定直播间弹幕、发送私信可以带空格
- 优化发送给其他直播间的弹幕也可以自动重发了
- 优化勋章升级的公告
- 优化检查变量窗口的大小
- 优化写入UTF-8文件添加BOM
- 优化JSON带有换行的问题
- 优化各语音实时更改发音人、音调等数值
- 优化点歌姬同时有多人点歌时进入队列
- 去掉点歌姬的试听接口
- 调整`sendToSockets`当cmd为空时发送给所有已连接的WebSockets
- 调整本地模式时可通过`>sendRoomMsg(roomId,msg)`来发送弹幕
- 调整Http的Event接口从安全限制开关改为过滤器的形式：`FILTER_API_EVENT`
- 修复点歌姬换源播放触发结束事件的问题
- 修复点歌姬拖动进度条的偏移问题
- 修复点歌姬搜索框变灰的问题
- 修复点歌姬立即播放在自动换源后不播放的问题
- 修复文件操作路径多余的斜杠
- 修复智能闲聊需要开关才能使用





### v4.5.0 [接收私信、微软语音、智能闲聊](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.5.0)

#### 新增功能

- 新增接收与处理私信功能
- 新增弹幕姬移动指示条，更明确地指示怎么移动位置
- 新增微软语音及SSML接口，十分逼真的语音合成
- 新增腾讯智能闲聊，AI回复又能用了
- 新增针对AI回复的操作，如作为私信回复、语音朗读
- 新增鼠标悬浮在人气值标签上显示x人看过
- 新增视频连线开始和结束的事件
- 新增五个私信示例：关键词自动回复、私信闲聊机器人、解析私信内容、生成Excel结果、批量导入Excel操作
- 新增两个列表示例：查看所有用户积分、查看所有用户打卡记录
- 新增连接直播间失败时自动重连
- 新增点歌姬搜索栏直接导入歌单
- 适配新的百度语音接口

#### 代码脚本

- 新增接收私信事件 `RECEIVE_PRIVATE_MSG`，详见文档“私信事件”章节
- 新增针对异步代码的回调逻辑，支持通过转义来嵌套
- 新增获取AI回复的结果命令：`aiChat`，可直接针对结果进行操作，不限制必须回复弹幕
- 新增获取指定代码块返回值：`getReplyExecutionResult`、`EventExecutionResult`
- 新增 csv 文件遍历的命令：`csvEachLine`
- 优化 `delay` 延迟有时候无效的问题
- 调整AI回复命令 `aiReply`，去掉第一个 id 参数
- 调整 `triggerReply` 命令不会触发未开启的回复（以前会）
- 调整 `appendFileLine` 和 `writeTextFile` 的第一个 dirName 参数，文件名可带路径

#### 优化与修复

- 修复上下移动代码失效的问题
- 修复非绿色版检测不到扩展的问题
- 修复弹幕插件舰长图片的问题
- 修复退出时崩溃的问题





### v4.4.2 [优化点歌姬](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.4.2)

- 新增获取屏幕指定位置颜色的命令（用于弹幕游戏）
- 新增歌曲因各种原因下载失败时自动换源，而非无法下载时才换源
- 新增精确点歌，只有点歌文字全部匹配才播放，避免错误点歌
- 新增点歌未找到歌曲的 `ORDER_SONG_NOT_FOUND` 信号
- 新增点歌黑名单统一使用小写字母
- 新增自定义变量支持等号，现在可统一管理多个一样的条件了
- 新增推广类型判断变量 `%spread%`，如"星光推广"
- 调整代码右键菜单的文字，“复制/粘贴片段”更容易理解
- 修复点歌姬网易云登录问题
- 修复点歌姬的一些暂停、跳过问题
- 修复上一版本更新后 `>cutOrderSong(username)` 失效问题





### v4.4.1 [百度语音、远程与多开](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.4.1)

- 新增**百度语音**支持，可切换发音人
- 新增语音播报的URL编码
- 新增**设置本地模式**命令，远程控制服务器上程序的总开关
- 新增`%app_name%`获取程序文件名，**作为多开的条件判断变量**
- 新增强制重连直播间命令
- 新增**导出所有上船记录表格**
- 新增获取分区ID和名字的变量
- 新增分区排行与人气值显示插件
- 新增连麦提示插件
- 新增系统 VC runtime 检测与提示
- 新增开播提示冷却
- 新增舰长过期提醒扩展
- 大幅度优化**模拟按键输入、鼠标操作**
- 优化网络代理，支持post
- 优化弹幕姬简约模式的颜色
- 去掉大乱斗尾声的文字提醒
- **修复点歌姬偶尔暂停的问题**





### v4.4.0 [扩展](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.4.0)

- 新增透明时钟、看板娘等多个扩展
- 新增自适应屏幕宽高的弹幕扩展
- 新增扩展获取主程序信息接口
- 新增代码控制音乐播放、添加点歌
- 新增网络代理接口，支持跨域
- 新增本地模式的动态控制
- 添加舰长数量%guard_count%
- 显示PK时故意送对面礼物的坏蛋
- 优化一部分扩展
- 修复讯飞语音无法播放的问题
- 修复PK获取匹配次数为零的问题
- 修复PK时断连导致崩溃的问题
- 修复弹幕翻译失效的问题
- 修复MacOS无法支付的问题





### v4.3.3 [修复bug](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.3.3)

- 新增自定义样式文件，更新不覆盖样式
- 新增查看云端屏蔽词
- 新增打开外部程序命令`startProgram`
- 新增点歌播放结束事件`SONG_PLAY_FINISHED`
- 新增README中的语法说明
- 修复点歌歌词路径问题





### v4.3.2 [修复bug](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.3.2)

- 新增三个方括号的条件格式
- 新增别名：setLocalName
- 优化“叫我xxx”中间需空格
- 优化托盘菜单为自定义样式
- 调整大乱斗结束的定时逻辑
- 修复参数中的特殊字符问题
- 修复托盘图标变方形的问题
- 修复弹幕姬窗口位置的问题





### v4.3.1 [弹幕扩展、自动更新](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.3.1)

- 新增支持添加实时弹幕到直播姬/OBS
- 新增代码触发时的动画
- 新增高能榜人数提示
- 新增setNickname失败的提示
- 新增理论上能用的自动更新
- 优化部分扩展的交互细节
- 优化网页扩展的开发API
- 优化简约模式不显示礼物价格
- 优化代码提示的情况
- 解锁一些付费才能使用的功能
- 修复网页配置无法保存的问题
- 修复高能榜总积分和为0的问题
- 修复保存主播头像变成圆形的问题





### v4.3.0 [网页扩展、大乱斗信息](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.3.0)

- 新增已安装的网页扩展的列表
- 新增快速打开扩展网页和添加到浏览器
- 新增在线抽奖扩展
- 新增部分扩展的配置页面
- 新增一键导入扩展代码
- 新增修改扩展的CSS样式
- 新增扩展配置页面
- 新增接收网页socket事件 `SOCKET_MSG_RECEIVE`
- 新增socket的cmd单独事件 `SOCKET:[cmd]`
- 新增支持网页扩展持久化配置
- 新增扩展自带jQuery/vue.js/Boostrap/MDUI
- 新增`www_path`等多个扩展相关的变量
- 新增显示大乱斗段位
- 新增显示大乱斗连胜场数
- 新增显示大乱斗助攻排行
- 新增显示大乱斗本赛季PK历史
- 新增大乱斗官网链接
- 新增大乱斗连胜事件 `PK_WINNING_STREAK`
- 新增背景颜色随着人气值缓慢浮动
- 新增获取对面直播间的高能榜积分总和
- 新增点歌姬的纯色背景
- 新增自定义捐赠版的显示文字
- 新增播放歌曲时不朗读弹幕
- 优化扩展的一些格式
- 优化界面小细节
- 优化昵称简化
- 修复打开对面主播首页的问题
- 修复修改CSV文件后的问题
- 修复加载直播间旧弹幕朗读的问题





### v4.2.0 [直播间设置、等待通道、扩展列表](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.2.0)

- 新增修改直播间标题、封面、公告
- 新增快速修改直播分区
- 新增一键上播、下播
- 新增保存主播头像、直播间封面
- 新增动态修改标题和封面命令
- 新增间隔发弹幕的等待通道
- 新增提升弹幕命令为房管权限
- 新增冷却通道和等待通道的变量
- 新增显示网页扩展列表
- 新增直接打开网络服务URL
- 新增一些醒目动画效果
- 新增设置桌面歌词字体
- 新增复制/粘贴文字命令
- 新增一些代码示例
- 新增交流群二维码
- 调整尊享版为捐赠版
- 优化4K下的控件大小
- 优化界面控件显示效果
- 优化弹出菜单交互细节
- 优化优惠券无效时的情况
- 优化点歌姬退出时立刻清理缓存
- 优化桌面歌词尺寸上限
- 修复部分音乐无法播放
- 修复咪咕音乐歌词问题





### v4.1.0 [云端屏蔽词、自动禁言](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.1.0)

- 新增云端屏蔽词：全站联合，自动增删
- 新增显示自动禁言表达式报错
- 新增显示直播间一些通知
- 新增支持特殊字符的匹配“[[xxx]]”
- 新增自动禁言后的通知支持变量\
- 新增关键词自动禁言过滤器
- 新增切换直播间显示历史弹幕
- 新增正则内置中文表达式
- 新增跑骚抓人定时刷新
- 优化4K缩放下部分控件尺寸
- 优化每天弹幕记录文件分割
- 优化事件去掉名字首尾空格
- 调整小心心报错的文字显示
- 修复支付时未登录账号的情况
- 修复获取优惠券失败的情况
- 修复条件判断中整数溢出的问题
- 修复关键词禁言非新人失效的问题
- 修复每日数据导出的缺失的标题





### v4.0.5 [酷狗点歌、本地音乐、伴奏模式](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.0.5)

- 新增“伴奏优先”模式，点歌优先搜索伴奏
- 新增点歌姬酷狗音源，支持自动换源
- 新增批量导入本地歌曲，自动搜索在线封面和歌词
- 新增支持显示语音弹幕
- 优化音源切换交互方式
- 修复 NEW_DAY 和 NEW_MONTH 的问题





### v4.0.4 [获取小心心、切换勋章、PK舰长播报](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.0.4)

- 新增大乱斗播报对面在线舰长数
- 新增点歌姬正在播放的封面接口
- 新增JSON容错机制
- 新增JSON的key支持变量
- 新增视频支持无边框窗口
- 新增视频支持切换画质
- 优化开播自动切换勋章（旧版只支持第一页）
- 优化聊天模式显示醒目留言
- 优化未开启禁言时也允许弹幕禁言
- 适配新错误：您发送弹幕的频率过快
- 修复小心心失效的问题
- 修复语音音量未重新读取的问题
- 修复关闭托盘后窗口启动时的位置问题
- 更多细节优化





### v4.0.3 [点歌姬优化、远程控制、修复崩溃](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.0.3)

- 新增显示各音乐平台账号
- 新增点歌姬歌词行间距设置
- 新增点歌姬优先播放收藏歌曲、空闲歌单
- 新增机器人账号登录结束事件
- 新增手机控制电脑（扩展）
- 新增数学计算：`abs/log/pow/...`
- 更新新版大乱斗的API
- 优化自适应主题色
- 优化导入QQ音乐歌单格式
- 修复发空消息崩溃的问题
- 修复搜索结果没有变色的问题
- 修复自动调整最长字数无效的问题





### v4.0.2 [细节优化、文件操作](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.0.2)

- 新增阻止所有自动回复的过滤器
- 新增默认使用六折优惠券
- 新增复制礼物 ID
- 新增开关右下角托盘
- 新增显示优惠券折扣
- 新增显示使用优惠券后的单价
- 新增通过UL等级自动调整弹幕字数上限
- 新增自定义连接时长
- 新增半夜温馨鼓励菜单
- 新增显示各直播间的统计数据
- 新增部分 IO 命令支持 `%n%` 换行
- 新增高能榜 `%online_rank%`
- 新增新船员数量事件 `NEW_GUARD_COUNT`
- 新增下载文件命令 `downloadFile`
- 新增插入文件指定位置 `insertFileAnchor`
- 新增读取文件每一行 `fileEachLine`
- 新增开关定时任务和修改时长 `enableTimerTask`
- 新增随机数组 `randomArray`，适用于抽奖
- 优化界面细节
- 为保护未使用神奇弹幕的主播利益，去掉偷塔相关
- 修复发送弹幕 msg repeat 问题
- 修复屏蔽天选无效的问题
- 修复 `%text%` 包含运算符 `~` 的问题
- 修复创建嵌套文件夹的问题
- 修复频繁更新高能榜
- 修复屏蔽吃瓜无效的问题
- 修复单机器人多直播间类型无效问题





### v4.0.1 [支付提醒](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.0.1)

- 优化未登录账号就支付时提醒





### v4.0.0 [界面重构、过滤器、打卡记录](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v4.0.1)

**注意**：从该版本起为付费版，专享功能：自动回复、事件动作、黑听视频

- **重构界面，重构界面，重构界面**，三遍*1
- **重构界面，重构界面，重构界面**，三遍*2
- **重构界面，重构界面，重构界面**，三遍*3
- 新增**过滤器机制**：点歌姬黑白名单、弹幕姬过滤，详见文档
- 新增**发送前替换**：替换某些发不出去的敏感词
- 新增代码**自动备份**与还原：在 `backup` 文件夹里，可手动还原以前代码
- 新增`triggerReply/Event`支持**沿用变量**，即%gift_name%等在其他事件可继续使用
- 新增快速**修改直播间标题**
- 新增代码**变量提示与自动补全**
- 新增Tab键跳过右括号
- 新增代码自动换行缩进
- 新增自动插入右括号
- 新增**点歌黑名单**
- 新增避免刷歌的数量设置
- 新增**正在播放**的歌曲的读取接口
- 新增点歌成功事件获取UID
- 新增**显示表格数据**，如积分、打卡记录
- 新增显示CSV文件，自动判断编码
- 新增表格按数值排序显示
- 新增右下角弹出通知卡片
- 新增打开程序窗口的代码
- 新增付费尊享版吊牌
- 新增投票扩展
- 新增显示主播签名、标签
- 新增显示本场直播弹幕数量
- 新增显示机器人头像
- 新增显示收到的氪金礼物
- 新增主页打开各种信息页面
- 新增累计启动次数
- 新增自定义清理长期不来的用户记录时长
- 新增大航海人数`%guard_count%`
- 新增粉丝团数量`%fans_club%`
- 新增`addValue`等三个修改命令
- 新增**词库判断**：`inFilterList()`
- 新增瀑布流设置页
- 添加 MDUI CSS库
- 优化支持 JS 文件使用域名配置
- 优化代码片段的高亮颜色
- 优化点歌默认支持繁体“點歌”
- 优化渐变背景色
- 优化代码框自动调整大小
- 调整`%guard_buy_count%`为单人上船次数
- 调整“开启/关闭AI回复”为“开启/关闭弹幕回复”
- “固定播放”重命名为“空闲播放”
- 去掉诟病已久的“您好”问候语
- 修复**每日打卡**没有自动重置的问题
- 修复舰长送小心心提示升级的问题
- 修复点歌姬主题变色影响到主程序的问题
- 修复`%fans_count%`为0问题
- 修复**舰长进入**没有时间导致不欢迎的问题
- 修复函数嵌套的问题





### v3.7.4 [天气预报、连胜统计、平滑滚动](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.7.4)

- 新增弹幕天气预报支持
- 新增正则提取、正则替换等命令
- 新增`PK_END`事件，支持连胜计数
- 新增右键菜单复制UID
- 新增列表控件平滑滚动
- 调整`appFileLine`编码为UTF-8
- 调整实时视频默认关闭截图模式
- 优化导入QQ音乐的格式
- 优化空歌曲时文件至少含一个空格
- 优化菜单展开的一瞬间支持快捷键
- 优化昵称简化
- 优化网络服务
- 修复`NEW_DAY_FIRST`问题
- 修复“粘贴代码片段”后重启出错
- 修复视频原画尺寸问题





### v3.7.3 [主播案例、修复变量](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.7.3)

- 添加官网和主播案例链接
- 添加轮播判断
- 添加直播间被超管切断提示
- 添加勋章升级调试信息
- 添加一些QA说明
- 优化localNotify等命令支持空文本
- 优化昵称简化
- 修复连着的%var1%%var2%问题
- 修复getData获取id显示科学计数法的问题
- 修复其他直播间的弹幕发到自己直播间的问题
- 修复打招呼变量失效的问题
- 修复启动时必定初始化语音模块的问题





### v3.7.2 [大乱斗播报、舰长黑听、随机数抽奖、特别关注答谢](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.7.2)

- 新增大乱斗对面粉丝数播报
- 新增大乱斗对面在线舰长播报
- 新增舰长黑听捕捉
- 新增随机数支持，用于抽奖
- 调整获取网络数据API，支持回调
- 新增支持特别关注答谢
- 新增支持热门榜播报
- 新增判断视频大乱斗的变量
- 新增第一次鼠标穿透提示
- 调整禁止自动发送的弹幕点歌（可改用命令点歌）
- 移除按索引调用动作的命令操作
- 修复非舰长高能榜进入闪退问题
- 修复粘贴代码后片段丢失问题





### v3.7.1 [保存礼物记录、大乱斗匹配信息、时间事件、自动参与节奏风暴](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.7.1)

- 新增保存本场直播所有礼物记录、舰长记录
- 新增远程添加违禁词
- 新增每日第一次打开事件
- 新增每周开始和结束事件
- 新增结束礼物答谢
- 新增截取字符串、昵称简化函数
- 新增调试快捷菜单
- 新增AI回复设置长度上限和重试
- 新增屏蔽用户进入消息
- 新增屏蔽节奏风暴、天选之子弹幕
- 新增自动参与节奏风暴领取亿圆
- 新增显示醒目留言价格
- 新增对面直播间弹幕、送礼等事件
- 新增大乱斗获取对面信息
- 新增解析网络JSON数据
- 调整字体为微软雅黑
- 调整动态偷塔上限
- 修复保存弹幕的文件路径未更新





### v3.7.0 [中文变量、人气记录、高能榜误作为舰长](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.7.0)

**注意：**
**点歌姬歌词编码更换为UTF-8，支持韩文等非GBK编码歌词，升级后旧歌词会乱码，需要清理缓存重新下载。**

- 支持中文变量，支持中文变量，支持中文变量
- 新增上船自动设置房管
- 新增醒目留言显示
- 新增输入对话框方法
- 新增多个变量
- 新增禁言用户不答谢示例
- 新增每日最高、平均人气
- 新增串门时间差判断
- 新增弹幕姬允许H5开关
- 添加addGameUser多个list的说明
- 恢复机器人弹幕点歌
- 修复高能榜识别为舰长的问题
- 修复点歌姬韩文歌曲乱码问题
- 修复自动回复插入出错的问题
- 修复保存弹幕文件有些天没有的问题





### v3.6.3 [咪咕音乐、QQ音乐VIP、每日签到、勋章升级、代码分享](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.6.3)

**注意**

- `REMOTE_BLOCK` 事件新增 `REMOTE_BLOCK_OVERRIDE`，前者不会覆盖自带回复
- `ORDER_SONG_SUCCEED` 事件新增 `ORDER_SONG_SUCCEED_OVERRIDE`，前者不会覆盖自带回复

更新内容

- 新增批量修改自定义变量 `setValuesIf`
- 新增天月年的开始结束事件
- 新增点歌与播放事件
- 新增代码批量复制粘贴
- 新增捐赠入口
- 新增默认设置代码
- 新增咪咕音乐源
- 新增签到打卡示例
- 新增勋章升级事件
- 新增当前歌曲播放
- 优化礼物连击答谢仅最贵的
- 支持QQ音乐VIP
- 支持三个音源自动切换
- 调整“函数操作”改为“命令操作”
- 去除自动回复的1.5s冷却
- 修复偶尔计算出错





### v3.6.0 [二维码登录、运算优化、绿色版](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.6.0)

- 二维码登录
- 支持绿色版与安装版（程序目录下创建`green_version`文件就是绿色版）
- 修复一行弹幕出现多个%{}%的问题
- 支持%[]%、%{}%等无限嵌套运算
- %()%查询用户支持专属昵称
- 全屏滚动弹幕不显示PK对面弹幕
- 支持代码注释、软换行等
- 支持房管远程控制开关
- 优化定时任务、自动回复、事件动作等代码的移动复制粘贴
- 优化重试的弹幕最先发送
- 启动弹幕姬时显示启动前弹幕
- 修复金瓜子int范围在土豪面前不值一提的问题
- 支持更多函数操作
- 新增自动打卡等示例





### v3.5.7 [开启大乱斗、高能榜欢迎](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.5.7)

- 新增函数：AI回复、大乱斗、设置专属昵称、忽略欢迎
- 新增示例：进场通知、自动大乱斗等
- 新增变量：舰长类型
- 新增高能榜用户进入通知
- 新增下播保存数据统计
- 优化定时连接周期
- 修复一些计算的问题
- 修复切换房间时舰长搞混
- 自动清理七天没来的用户进入记录，避免卡顿





### v3.5.6 [自定义弹幕样式、自动调整大乱斗礼物上限](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.5.6)

- 新增自定义弹幕样式
- 新增弹幕气泡
- 新增送礼金额显示
- 新增Web开发文档
- 新增自动调整偷塔上限开关
- 优化部分昵称简化
- 优化不朗读大乱斗对面直播间的弹幕
- 优化重复播报开播的情况
- 修复对面主播串门问题
- 修复大乱斗最佳助攻没有UID的问题





### v3.5.5 [礼物记录、调试模式、视频裁剪](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.5.5)

- 新增保存上船记录、礼物记录
- 新增导出每日记录为CSV表格
- 新增实时视频图片裁剪
- 每天零点重新统计数据，尽管仍然在直播
- 添加调试模式
- 优化实时视频默认为截图模式，修复打不开
- 支持自定义点歌回复事件
- 判定主播也属于房管
- 修复大乱斗新赛季失效问题
- 鼠标穿透添加关闭按钮





### v3.5.4 [礼物连击、歌词读取、弹幕禁言、未开播时回复](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.5.4)

- 新增礼物延迟统计答谢
- 新增歌词读取接口
- 新增手动标记为非机器人
- 新增本地调试输出模式
- 新增随机播放的洗牌算法
- 新增忽略仅直播时回复
- 优化弹幕禁言的回复
- 添加大乱斗蹭积分卡示例
- 保存头像到本地，减少内存占用
- 修复PK对面触发自动回复问题





### v3.5.3 [优化AI回复、新增示例](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.5.3)

- 添加一些示例
- 新增发送长文本函数
- 新增PK即将结束动作
- 新增AI回复自定义ID和KEY
- 头像保存到文件，减少内存占用
- 点歌姬编码改为UTF-8
- 调整歌曲列表
- 修复AI回复会回复自己
- 修复“未搜到人和歌曲”





### v3.5.2 [上船事件、视频截图、跑骚抓人、QQ群推送、弹幕切歌、服务器支持](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.5.2.1)

- 新增开启网络服务端
- 新增浏览器访问点歌列表
- 新增直播界面送礼动画
- 新增支持执行命令行
- 新增弹幕内计算
- 新增条件支持正则表达式
- 新增跑骚抓人，遍历关注列表
- 新增实时视频控制
- 新增原画预先截图
- 新增自动赠送到期礼物
- 新增QQ群推送方案
- 新增在线获取小心心
- 新增舰长/房管/会员等判断
- 新增文字+1发送
- 新增查看大乱斗对面数据
- 新增弹幕远程切歌操作
- 新增判断房间已有舰长
- 新增用户初次上船事件
- 新增PK最佳助攻事件
- 新增开机自动启动设置
- 新增播放声音函数
- 新增机器人判断仅限关注
- 新增PK双方直播间关注事件
- 优化事件的冷却值默认为0
- 优化永久禁言按房间设置
- 优化舰长昵称显示
- 添加帮助说明文档
- 修复讯飞API设置问题
- 修复冷却时间问题
- 修复大乱斗开播问题
- 修复歌词毫秒位解析错误





### v3.2.1 [发送私信、AI弹幕回复、事件触发器、播放会员与无版权歌曲、讯飞语音](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v3.2.1)

- 新增支持发送私信
- 新增用户永久禁言
- 新增语音属性设置
- 新增CMD事件功能
- 新增讯飞语音API支持
- 新增单用户上船次数统计
- 新增单用户初次上船判断
- 新增程序启动动画
- 新增AI回复弹幕
- 新增点歌显示用户
- 新增QQ音乐播放源
- 新增网易云会员登录
- 新增指定歌手精确点歌
- 新增无版权音乐自动换源
- 调整自动签到至0点多
- 优化点歌姬界面交互
- 优化点歌必须加空格
- 优化设置为房管提示
- 优化大乱斗重新录播
- 优化启动时隐藏主窗口
- 优化菜单图标
- 优化礼物连击
- 优化启动时大乱斗判断
- 修复反偷塔失效问题
- 修复大乱斗下播误判





### v2.9.2 [舰长通知、实时关注、自动签到、匿名跑骚、关键词回复](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v2.9.2)

- 新增舰长通知
- 新增实时关注答谢
- 新增代码语法高亮
- 新增背景图片模糊
- 新增设置礼物别名
- 新增每日自动签到
- 新增直播间切换动画
- 新增自动参加天选时刻
- 新增任意直播间状态查询
- 新增任意直播间匿名跑骚
- 新增只在开播时发送弹幕
- 新增自定义发送框快捷键
- 新增冷却通道，强制欢迎
- 新增多个可编程函数操作
- 新增可编程游戏用户列表
- 新增开播自动切换粉丝勋章
- 新增状态栏显示粉丝和排名
- 新增视频大乱斗刷新实时视频
- 新增所有弹幕都判断禁言开关
- 新增关键词自动回复，支持变量
- 新增大乱斗去对面串门回来的提示
- 新增发送弹幕至大乱斗对面直播间
- 捕获更多CMD并通知
- 优化昵称简化算法
- 优化欢迎单独一页
- 优化关注消失的时间
- 优化欢迎时的次数判断
- 优化定时任务手动发送
- 优化全屏滚动弹幕不重叠
- 更多小细节优化
- 修复反偷塔上限计算失误
- 修复网络卡顿导致程序卡顿
- 修复点歌姬每次都打开历史
- 修复定时任务疯狂输出的问题





### v2.7.4 [优化界面、点歌机、匹配新的大乱斗规则](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v2.7.4)

- 大幅度提升界面效果
- 大幅度简化Cookie设置流程
- 添加点歌可选要求粉丝勋章
- 更加人性化的点歌设置与交互
- 匹配新大乱斗赛季：1乱斗值=100金瓜子





### v2.7.2 [简约模式、录播、语音](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v2.7.2_x64)

- 自动录播
- 全屏滚动
- 语音播报
- 房间快捷键
- 机器人判断
- 右键菜单自动显示粉丝数等信息
- 最小化到托盘
- 简约模式
- 聊天模式
- 自动欢迎黑名单





### v2.5.1 [点歌姬、大乱斗串门与消息同步](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v2.5.1_x64)

- 全自动点歌姬（可作为单独音乐播放器）
- 显示大乱斗主播昵称
- 大乱斗串门小报告
- 大乱斗双方弹幕同步
- 直播视频预览
- 简单的抽奖机
- 礼物连击自动合并
- 发送长文本弹幕分割
- 本地消息通知
- 直播姬录制模式
- 优化大乱斗结局判断
- 优化后台挂机逻辑
- 调整存储文件位置
- 更多操作细节





### v1.8.2 [大乱斗自动偷塔、可编程变量集](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v1.8.2)

- 新增大乱斗PK时最后几秒使用吃瓜偷塔（注意钱包）
- 新增动态可编程变量
- 新增编程逻辑运算，按条件发送自动弹幕
- 新增随机弹幕优先级设置
- 新增直播间弹幕远程控制机器人
- 新增偏僻中文拼音提示
- 修复诸多bug





### v1.6.1 [禁言、统计](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v1.6.1)

- 喷子自动禁言
- 直播数据统计
- 定时连接B站WS服务器
- 显示头像和粉丝牌等





### v1.2 [实时弹幕、自动欢迎和答谢、自动翻译和回复、定时弹幕、特别关心](https://github.com/iwxyi/Bilibili-MagicalDanmaku/releases/tag/v1.2)

- 实时显示弹幕
- 小窗弹幕聊天
- 自动欢迎进入
- 自动感谢送礼
- 点歌自动复制
- 快速百度搜索
- 外语自动翻译
- 自动沙雕回复
- 定时发送弹幕
- 特别关心高亮
